<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Options;
use Twilio\Values;

abstract class InsightsSegmentsOptions
{
    /**
     * @param string $token The Token HTTP request header
     * @return FetchInsightsSegmentsOptions Options builder
     */
    public static function fetch(
        
        string $token = Values::NONE

    ): FetchInsightsSegmentsOptions
    {
        return new FetchInsightsSegmentsOptions(
            $token
        );
    }

    /**
     * @param string[] $reservationId The list of reservation Ids
     * @param string $token The Token HTTP request header
     * @return ReadInsightsSegmentsOptions Options builder
     */
    public static function read(
        
        array $reservationId = Values::ARRAY_NONE,
        string $token = Values::NONE

    ): ReadInsightsSegmentsOptions
    {
        return new ReadInsightsSegmentsOptions(
            $reservationId,
            $token
        );
    }

}

class FetchInsightsSegmentsOptions extends Options
    {
    /**
     * @param string $token The Token HTTP request header
     */
    public function __construct(
        
        string $token = Values::NONE

    ) {
        $this->options['token'] = $token;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self
    {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.FetchInsightsSegmentsOptions ' . $options . ']';
    }
}

class ReadInsightsSegmentsOptions extends Options
    {
    /**
     * @param string[] $reservationId The list of reservation Ids
     * @param string $token The Token HTTP request header
     */
    public function __construct(
        
        array $reservationId = Values::ARRAY_NONE,
        string $token = Values::NONE

    ) {
        $this->options['reservationId'] = $reservationId;
        $this->options['token'] = $token;
    }

    /**
     * The list of reservation Ids
     *
     * @param string[] $reservationId The list of reservation Ids
     * @return $this Fluent Builder
     */
    public function setReservationId(array $reservationId): self
    {
        $this->options['reservationId'] = $reservationId;
        return $this;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self
    {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.ReadInsightsSegmentsOptions ' . $options . ']';
    }
}

